
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 16:25:49 2005
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version CRYS_ATP_TST_DH_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
    
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */   
    
/***************************
 * File Name:                                                           
 *  CRYS_ATP_TST_DH_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for DH Acceptance tests                               
 *
 **************************/


/***** Include Files **********/
#include "CRYS_ATP_TST_DH_Acceptance.h" 
#if TST_USE_DH_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines *********/
/******** Enums *********/
/******** Typedefs ********/
/******** Global Data *******/
/***** Private function prototype *****/
/******** Public Functions ******/
/****/
/* PKCS#3 */
/****/
TST_DH_TestDataStructPKCS3 TST_DH_Acceptance_PKCS3_TestDataStruct[] = 
{
    #if TST_USE_DH_512_PRIME
    { 
        {"Acceptance test - DH PKCS#3/Prime-512/Generator-512/l=0"},
        /*TST_Generator - G*/
        {0xd4,0x07,0xa9,0x80,0xaf,0xc2,0x7a,0x5b,0x61,0x22,0x76,0x29,0x1d,0x65,0x52,0x59,
         0x7f,0x4f,0x17,0x7a,0xa1,0xea,0x04,0x02,0x8c,0x8b,0x01,0x11,0x72,0x2b,0x4d,0xc3,
         0x78,0xc0,0x08,0x11,0x01,0xcd,0x45,0xab,0xb3,0x05,0x56,0xcd,0x72,0x52,0x16,0x7c,
         0x74,0xf1,0x00,0x77,0xa4,0xf3,0x31,0x83,0x50,0xc3,0xed,0x3b,0xb5,0xb5,0x5d,0x43},  
        /*TST_GeneratorSize;*/
        64*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xfc,0xf6,0xd3,0x9e,0x31,0x88,0x25,0x66,0x30,0x74,0x1c,0x03,0x85,0x6e,0xbd,0xea,
         0x02,0x01,0x0b,0x77,0x43,0x35,0xfe,0x57,0x9c,0x60,0xd5,0x24,0x22,0xbe,0x99,0xeb,
         0x4f,0x8f,0x95,0x77,0xdc,0x47,0x6a,0x5e,0x31,0x21,0x6e,0x9c,0x00,0x1b,0x55,0xa7,
         0xed,0xc4,0xcd,0xf2,0x31,0xd2,0x44,0x60,0x10,0xd4,0xb2,0x6c,0xb6,0xf4,0xb3,0x73},
        /*TST_PrimeSize*/
        64*sizeof(DxUint8_t),
        /*TST_L*/
        0,        
    }, 
    #endif
    #if TST_USE_DH_1024_PRIME
    {
        {"Acceptance test - DH PKCS#3/Prime-1024/Generator-1024/l=0"},
        /*TST_Generator - G*/
        {0xc4,0x3b,0x36,0xc8,0xe7,0xa9,0x60,0xea,0x35,0x80,0x6a,0x02,0x6a,0x02,0x02,0xcb,
         0x21,0x24,0x3d,0xb8,0x3d,0x01,0x76,0x63,0x8a,0xee,0x95,0x50,0x94,0x1d,0x6f,0x0c,
         0x6f,0x84,0x17,0x16,0x24,0x00,0x27,0xe2,0x01,0x8a,0xa8,0xa4,0xdf,0x7e,0xde,0xb4,
         0x49,0x20,0x2c,0x8f,0x34,0x3b,0xa1,0x4e,0x6b,0x02,0x23,0x11,0x42,0x9a,0x9c,0xba,
         0x22,0x15,0x06,0x1c,0x26,0x39,0x1c,0xdb,0x43,0xd3,0x2c,0x75,0x96,0xaf,0x97,0xcf,
         0xa9,0x32,0xa1,0xa7,0x3f,0x90,0xa9,0xa8,0x1d,0xb8,0x48,0xcc,0x2e,0x68,0xc1,0xf1,
         0x71,0xd2,0xfb,0x4f,0xda,0x9c,0x89,0x02,0xea,0x89,0x9b,0xa2,0xe9,0x33,0xc4,0xfe,
         0x7a,0x31,0x39,0x71,0x12,0x18,0xb9,0xbe,0x33,0x10,0xcf,0x1b,0x65,0xcb,0xc1,0x73},  
        /*TST_GeneratorSize;*/
        128*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xc4,0xac,0x0a,0xd9,0x6a,0xf5,0xb1,0x93,0x46,0x43,0xac,0x5b,0x2e,0x45,0x38,0x29,
         0x4e,0x24,0xde,0x8f,0x80,0x28,0x6c,0x4a,0xef,0xcb,0xc2,0x07,0xe5,0xae,0xec,0x4f,
         0x9a,0x1b,0x1b,0x61,0x35,0xdb,0xf9,0x88,0x83,0x61,0x4e,0xca,0x8e,0x82,0x43,0xf9,
         0x56,0x9f,0x4c,0xb0,0x28,0xbc,0xa9,0x9a,0x23,0x05,0xbd,0x08,0x7d,0xc6,0x3b,0x62,
         0x8f,0x2a,0x96,0x30,0xcf,0x29,0x6f,0x1c,0x18,0x54,0x57,0x9f,0xcb,0xf3,0xb0,0x85,
         0xb9,0xce,0xea,0xce,0x71,0x7a,0x16,0x05,0xb3,0xeb,0xf4,0xf6,0x99,0xd2,0x7c,0xe8,
         0x0e,0x36,0x01,0x3f,0x87,0x6c,0x4a,0xfc,0x45,0x67,0x09,0x5c,0xcb,0x09,0x9a,0x5b,
         0x96,0x61,0xd3,0x35,0x1a,0x04,0x07,0xa8,0x68,0xe4,0xc4,0xb1,0x3b,0x11,0xd7,0xa3},
        /*TST_PrimeSize*/
        128*sizeof(DxUint8_t),
        /*TST_L*/
        0,        
    },
    #endif
    #if TST_USE_DH_2048_PRIME
    { 
        {"Acceptance test - DH PKCS#3/Prime-2048/Generator-2048/l=0"},
        /*TST_Generator - G*/
        {0xc9,0x16,0xa6,0x54,0x91,0xa7,0x1c,0xdf,0x9b,0xf9,0x59,0x07,0x95,0x06,0x4f,0xfa,
         0x95,0x79,0xc5,0x20,0x47,0xa4,0x75,0xce,0x49,0xb5,0x3c,0xfa,0x91,0xd4,0xd2,0xb5,
         0xe5,0x6b,0x36,0x24,0x5f,0x90,0x8e,0xfb,0x7a,0x1b,0x41,0xf7,0x18,0x41,0xfc,0x7b,
         0xa5,0xb4,0xc3,0xe1,0x71,0xb4,0x66,0x54,0x02,0x0a,0xd3,0xd9,0xd2,0x9d,0xe6,0x18,
         0x6d,0x2a,0xb7,0xdb,0x45,0xbe,0xc1,0x83,0x7f,0x94,0x5b,0xd7,0xd8,0x98,0xd2,0xcf,
         0x54,0x38,0x39,0xda,0x90,0x86,0xcc,0xab,0x0f,0x15,0xf8,0xb8,0xbf,0xde,0x50,0x07,
         0x74,0x45,0x84,0x4c,0x2f,0x08,0xb1,0x2f,0x40,0x49,0x9c,0xaf,0xb6,0xd1,0x6c,0xe3,
         0x45,0xbf,0xf1,0x63,0xcc,0x77,0x66,0x5d,0x45,0x35,0xb9,0x0a,0xac,0x74,0x14,0x91,
         0x64,0x1b,0x34,0x50,0xb4,0xa0,0x1e,0xd9,0xa9,0x62,0x56,0x57,0xcb,0x73,0x3c,0x96,
         0x5f,0x86,0x7f,0xc3,0x66,0xbf,0xac,0x79,0x21,0x51,0x14,0x3f,0x37,0x29,0xbe,0x96,
         0xc8,0xee,0xf1,0xaf,0x4e,0xc7,0x9f,0x83,0x20,0xe7,0xb5,0xb2,0x52,0x57,0xcc,0xa8,
         0xb0,0xf2,0x4d,0x88,0x3e,0x71,0xfb,0xd7,0x45,0x4d,0x96,0x0b,0xcb,0x24,0x0a,0x88,
         0x4f,0xaf,0xe8,0x96,0x79,0x87,0x14,0xf8,0x1e,0x3d,0xf7,0x2c,0x48,0xf7,0x0e,0x52,
         0x4e,0x3d,0xcb,0xeb,0x57,0x54,0xb9,0x90,0xe1,0x14,0x5c,0x36,0x7d,0xc0,0xa3,0x5f,
         0xf4,0xfd,0xf6,0x33,0x23,0x7e,0xf2,0xd0,0xff,0x0d,0xe0,0xe2,0xa3,0xcc,0x81,0x86,
         0xbc,0xde,0x67,0x83,0x03,0xd6,0xfa,0x5b,0x42,0xd3,0x1f,0xfe,0xd2,0x0f,0x2b,0x1b},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xce,0xd3,0x02,0x09,0x7d,0xe5,0x34,0xf5,0x3f,0x14,0x2e,0x7b,0x3e,0x15,0x4c,0x66,
         0x2c,0xe1,0xf0,0xb7,0x40,0x72,0x68,0xfa,0xad,0xa6,0xd5,0xd9,0x55,0x1e,0x7e,0xfd,
         0x06,0xbc,0x4f,0xb8,0x27,0xe9,0x22,0x3d,0x17,0xfa,0x4d,0x8c,0x8b,0x8e,0xce,0xf6,
         0xc9,0x49,0x38,0x74,0xa2,0x77,0x3b,0x9a,0xe1,0xc0,0xa7,0xc8,0x83,0xf9,0xdc,0xa7,
         0x9a,0x12,0xc5,0x19,0x5c,0xfb,0x40,0x0c,0x08,0x57,0xa1,0xf7,0x8d,0xf2,0x10,0x83,
         0xe8,0xe7,0x8a,0xc1,0x0c,0x59,0xa1,0xa3,0x77,0xb1,0x9f,0x0d,0x0f,0xf8,0x27,0xdd,
         0xdc,0xed,0xbf,0x04,0x91,0xa3,0x00,0x19,0x08,0x2d,0x7c,0xc9,0xda,0xfb,0x05,0x31,
         0xf5,0x34,0x0d,0xaa,0xd3,0xbb,0xc0,0x5b,0xfb,0xad,0x32,0x6b,0x98,0x00,0x17,0x01,
         0x39,0x61,0x0e,0x03,0x2e,0xf6,0x60,0x30,0x7b,0xb9,0xeb,0x39,0x60,0x1b,0xc4,0x7f,
         0xe5,0xcb,0x5f,0xc3,0xb0,0x79,0xdb,0x04,0xd2,0x9a,0x11,0x95,0x3e,0xa4,0x33,0x61,
         0x8e,0x94,0x22,0x9b,0x0a,0xd0,0xfb,0xda,0x07,0xc7,0x34,0xfb,0xa9,0x94,0xc8,0x31,
         0x03,0xe1,0x92,0xac,0x86,0xfc,0x45,0xe3,0x79,0x0b,0x9e,0x29,0x63,0xe8,0xcf,0x26,
         0x05,0xb3,0x6e,0xa9,0xae,0x9d,0xe3,0xdc,0x03,0x43,0x26,0xdf,0x7e,0x8b,0xae,0xcb,
         0xe8,0x09,0x04,0x25,0xdd,0x42,0xb8,0x59,0x44,0xec,0xc1,0xc7,0xbf,0x78,0x50,0x31,
         0xec,0x6e,0xa5,0x5f,0xe4,0x4f,0x79,0x7b,0xf3,0xbf,0x03,0xd3,0xa9,0x7b,0x7c,0x70,
         0xa2,0x5f,0xdb,0x86,0x96,0xfa,0xd1,0x3f,0x43,0xc5,0xd2,0x2a,0xf8,0xf3,0x3c,0x7b},
        /*TST_PrimeSize*/
        256*sizeof(DxUint8_t),
        /*TST_L*/
        0,        
    },
    #endif
    #if TST_USE_DH_512_PRIME
    { 
        {"Acceptance test - DH PKCS#3/Prime-512/Generator-512/l=10"},
        /*TST_Generator - G*/
        {0xc4,0x0d,0x90,0xd4,0xac,0x8d,0xba,0x55,0xe9,0x0d,0xef,0x2a,0xa9,0x23,0x87,0x79,
         0x67,0x8a,0x8f,0x7a,0xb9,0xa4,0x81,0x76,0xc4,0xa9,0x6c,0x99,0xe2,0xbc,0x6b,0x40,
         0x96,0xd0,0xbf,0xd7,0x1c,0x31,0xe0,0x89,0xd8,0x36,0x5b,0xb3,0xc7,0xc2,0xbf,0x4f,
         0x1c,0xc7,0x6a,0xf7,0xa5,0x26,0xc7,0x26,0x83,0x13,0xa2,0x5b,0xd1,0x92,0xff,0x61},  
        /*TST_GeneratorSize;*/
        64*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xe0,0x37,0x1c,0x4c,0xff,0x1f,0x66,0x2e,0xe5,0x63,0x1c,0x97,0x4f,0x3e,0x57,0xc5,
         0x21,0x49,0x2f,0xd8,0xfe,0x33,0xef,0x07,0x95,0x08,0x99,0x9b,0x28,0xb3,0x59,0x6a,
         0x8e,0x8f,0x23,0x81,0xb6,0x98,0x73,0x64,0x07,0xa9,0x48,0xc3,0x65,0x2b,0xb8,0xee,
         0x55,0xcf,0x87,0xe1,0xca,0xe7,0xc4,0x5b,0x28,0xd2,0x08,0x02,0xa6,0x2b,0x7e,0x07},
        /*TST_PrimeSize*/
        64*sizeof(DxUint8_t),
        /*TST_L*/
        10,       
    },  
    #endif
    #if TST_USE_DH_1024_PRIME
    {
        {"Acceptance test - DH PKCS#3/Prime-1024/Generator-1024/l=11"}, 
        /*TST_Generator - G*/
        {0x33,0x38,0xa5,0x92,0xda,0x5b,0xb1,0x69,0x8b,0x92,0x44,0x87,0x7b,0xcb,0x9d,0x1a,
         0x84,0xf4,0x07,0x57,0x44,0xe6,0xa1,0x1d,0xb6,0x50,0xd3,0x41,0xc7,0x89,0x08,0x06,
         0x53,0xdc,0x46,0x4b,0xa1,0xb7,0x0e,0x02,0x49,0x37,0xb5,0x4c,0xb0,0xb4,0x58,0x38,
         0x35,0xc9,0x94,0xca,0xcb,0x6e,0x0b,0xa9,0xfc,0xb9,0xb8,0x73,0x0e,0x6d,0xdd,0x13,
         0xf1,0xfb,0xe7,0xa6,0x21,0x2b,0x63,0xe5,0x0d,0xe8,0x77,0x7e,0x5c,0xfb,0xd4,0x02,
         0x12,0x31,0xb8,0x20,0x42,0x13,0x6b,0xdf,0x0e,0xdb,0xbb,0x0e,0xb6,0xd5,0xaa,0x94,
         0x62,0xb1,0x48,0x9f,0x18,0xf8,0xab,0x59,0x9a,0x36,0x28,0x99,0x56,0xcd,0xef,0xfa,
         0x42,0x46,0xfb,0xe5,0x15,0xa3,0x6a,0x34,0x6b,0xd3,0xc6,0xc1,0x6c,0x6c,0x7c,0x4d},  
        /*TST_GeneratorSize;*/
        128*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xbd,0xc0,0x4f,0xd0,0x12,0x80,0x59,0xe8,0xd5,0x10,0x1b,0x76,0x2f,0xb6,0x0a,0x03,
         0xfe,0xa5,0xcf,0x0c,0xd6,0xc5,0x8d,0xa8,0x71,0xc6,0xa1,0xd9,0x2c,0x1a,0x8f,0xcc,
         0xc5,0xb4,0xde,0xe7,0x80,0x59,0x99,0x22,0x18,0x99,0x99,0x4b,0x0f,0x2a,0x6d,0x42,
         0xe5,0xd9,0x3a,0x22,0x4c,0x72,0x30,0x6b,0x51,0xe2,0x95,0x6f,0x5d,0x3f,0x63,0x84,
         0xbd,0x72,0x41,0x1c,0x1f,0xcc,0xad,0x70,0x1c,0x61,0x12,0xd8,0xfb,0xcb,0x6c,0x7e,
         0x9e,0x0c,0xff,0x30,0xa1,0xa1,0xc1,0x99,0xb7,0x08,0x67,0xa2,0x03,0x83,0x05,0xbf,
         0x52,0x7d,0x83,0xf8,0x05,0x1e,0x1b,0x64,0x6f,0xc5,0xac,0xc4,0xcf,0x42,0xbb,0x7c,
         0x4f,0x89,0xfa,0x7c,0x2e,0x7c,0xdf,0x6d,0x32,0x75,0xff,0xba,0x4e,0x62,0xdc,0xd1},
        /*TST_PrimeSize*/
        128*sizeof(DxUint8_t),
        /*TST_L*/
        11,       
    },
    #endif
    #if TST_USE_DH_2048_PRIME
    { 
        {"Acceptance test - DH PKCS#3/Prime-2048/Generator-2048/l=12"}, 
        /*TST_Generator - G*/
        {0xc0,0x27,0xaf,0xaf,0x57,0x1a,0x9e,0xd6,0x9a,0x24,0x2f,0xef,0x31,0x30,0x58,0xba,
         0x14,0x77,0xdc,0x60,0x11,0x43,0x10,0x4a,0x80,0xe3,0xd8,0xa6,0xe3,0x00,0x11,0x87,
         0x24,0x8f,0x3c,0xf6,0x48,0x4f,0xfd,0xd7,0x22,0x4c,0x76,0xb0,0xaa,0xb4,0x22,0xe9,
         0xd4,0xb7,0xed,0x9a,0x1a,0xea,0xa2,0x01,0x57,0x52,0xb0,0x9e,0xae,0x3e,0x45,0x3a,
         0x1e,0x56,0x5b,0xda,0x4d,0x35,0x67,0x2a,0xb8,0x9d,0x77,0xb0,0xa8,0x5e,0xc8,0xd4,
         0x06,0x82,0x5f,0x15,0x82,0xe5,0x45,0x8f,0xf6,0x9a,0xab,0x5c,0x96,0x38,0xcc,0x19,
         0x94,0x2d,0xc5,0x25,0x40,0x24,0x4c,0x3f,0xc7,0x8d,0x08,0x5b,0x68,0x21,0xb2,0xb6,
         0x4f,0x1a,0x1f,0x42,0x3b,0xf4,0x9c,0x0b,0x98,0x10,0xd5,0x56,0xac,0x88,0x4b,0x8c,
         0x39,0x79,0xde,0xf7,0xca,0xfc,0x31,0xaf,0x67,0x91,0x0b,0xb7,0xcd,0x67,0x01,0x72,
         0x8a,0x52,0xc1,0xf5,0x98,0x97,0x47,0x36,0x23,0xab,0x8e,0xf5,0x8a,0x30,0xf4,0x62,
         0x07,0x55,0x57,0x7e,0xf9,0xa1,0x76,0x4c,0xa8,0xb0,0xe0,0xc9,0xb1,0xa0,0x86,0x5e,
         0xc9,0x13,0x36,0xe7,0xdd,0x02,0x89,0xf6,0x0b,0x0c,0xf4,0x49,0xf7,0xa6,0xcb,0x03,
         0xb7,0x80,0x54,0xbf,0x5b,0xeb,0x6b,0x92,0xfd,0x62,0xe0,0x2a,0xb0,0x6c,0xeb,0x6d,
         0x34,0x1d,0xe1,0x89,0x92,0xcb,0x21,0xbc,0x53,0x45,0x1b,0x13,0xa8,0xe2,0xb6,0x50,
         0xd4,0xf5,0x3a,0x44,0x52,0x5c,0x10,0x08,0x0a,0x95,0xfc,0x6a,0x2c,0x92,0xc0,0x21,
         0x73,0xc5,0xab,0x6e,0x94,0x3e,0x0f,0x6b,0xd2,0xa4,0x85,0xea,0xd9,0x20,0x98,0xd5},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xd3,0xa2,0x3a,0xbc,0xcc,0xa2,0xe7,0xc3,0x39,0x2a,0x8b,0x5c,0x8a,0x3c,0x29,0x39,
         0xa1,0xef,0xf4,0xe2,0x06,0x79,0xae,0x2b,0xca,0xde,0xad,0x84,0x91,0xcd,0xe6,0x3a,
         0x07,0x24,0xaa,0x4d,0xa0,0x02,0xea,0xe2,0xb2,0xd6,0xcb,0x3a,0xf3,0x2b,0x8c,0x92,
         0xaa,0xea,0x47,0x9f,0x5b,0xc7,0xf8,0xfe,0xf8,0x09,0x6e,0x1a,0x3a,0xcc,0x22,0x9b,
         0xb5,0xe2,0x6b,0x4e,0xab,0x67,0xc6,0x25,0x24,0xd7,0x17,0x92,0x73,0x37,0xd1,0x2b,
         0x90,0xab,0xa0,0xeb,0xf9,0x2e,0x1d,0xe7,0xc3,0x29,0x5d,0x78,0x46,0x0f,0xf4,0x2b,
         0xb1,0xa5,0x71,0xfb,0x43,0xba,0x19,0xa6,0x59,0xca,0x20,0xc2,0x2f,0x33,0x0e,0xae,
         0xec,0xcd,0x23,0x1a,0x54,0x83,0xe7,0x7a,0x83,0x58,0xc5,0xc2,0x71,0xb3,0x9e,0xad,
         0x64,0x3f,0x4f,0x63,0xb4,0xf4,0xa5,0x6f,0xa4,0x66,0x10,0x62,0x00,0xa7,0x30,0x2f,
         0x7d,0x37,0x2a,0x97,0xc0,0xc6,0x9b,0x13,0x2d,0x11,0x95,0x20,0x2c,0x2c,0x68,0x81,
         0x70,0x30,0xf0,0xa7,0x45,0x12,0x4c,0xbf,0x99,0xa3,0xd3,0x70,0x26,0x00,0x2e,0x4a,
         0xc6,0xdc,0x59,0xe9,0xdf,0x1c,0x1f,0x1a,0xd5,0x02,0xe5,0xda,0xe7,0x5f,0xb4,0x4d,
         0x39,0x82,0xf0,0x81,0xd1,0x6b,0xd8,0xda,0xf5,0xa4,0x33,0x53,0xe9,0x9a,0x75,0x5a,
         0x8e,0x95,0xcb,0x8a,0xcf,0x82,0x5b,0x8d,0x65,0x9b,0x7d,0x72,0x64,0x57,0xfa,0x7a,
         0xdb,0x3e,0x5f,0x5b,0xa5,0x92,0x14,0xea,0xa3,0xbb,0xf6,0xa9,0x70,0x41,0xfa,0x8b,
         0xe9,0x80,0x75,0xe7,0xa6,0x5d,0xdf,0x54,0xee,0x10,0x41,0x6c,0x5b,0xbc,0x64,0xa1},
        /*TST_PrimeSize*/
        256*sizeof(DxUint8_t),
        /*TST_L*/
        12,       
    },  
    #endif
};
/*****/
/* ANSI942 */
/*****/
TST_DH_TestDataStructANSI942 TST_DH_Acceptance_ANSI942_TestDataStruct[] = 
{
    #if TST_USE_DH_512_PRIME
    { 
        {"Acceptance test - DH ANSI9.42/Prime-512/Generator-512/Q-512/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"}, 
        /*TST_Generator - G*/
        {0xd6,0x7a,0x0c,0x91,0x78,0x14,0xad,0x34,0xf0,0xa8,0xa4,0x41,0x36,0x43,0x40,0xe6,
         0xf2,0xc4,0x74,0x05,0xda,0x85,0x39,0x81,0x4e,0xab,0x68,0xd6,0xba,0x86,0xb9,0xa8,
         0x64,0x78,0x7e,0x3d,0x1e,0xc3,0xb0,0x2f,0x83,0xf7,0x9a,0x15,0x0f,0x09,0xa4,0xdb,
         0x28,0x50,0x93,0x36,0x7c,0x73,0xb0,0xf5,0xc9,0xfb,0x61,0x61,0xcb,0xed,0x73,0x87},  
        /*TST_GeneratorSize;*/
        64*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xf2,0xf4,0xd0,0x43,0xc6,0xee,0x9d,0xb6,0x00,0x49,0x9a,0x7b,0x7d,0x5f,0x63,0x65,
         0x4e,0x91,0xa7,0x36,0xe4,0x75,0x04,0x80,0xb9,0x04,0xa4,0xf8,0x9d,0xde,0x51,0x4e,
         0xbf,0xdc,0x7b,0x79,0xdf,0xe3,0x4f,0xd1,0xd5,0x3f,0xb8,0x75,0xbe,0xd4,0xaa,0x9a,
         0x6b,0x37,0xdb,0x58,0xe1,0x95,0xe1,0xfa,0xdf,0xbc,0x9e,0x31,0xc5,0xb4,0x6b,0xcf},
        /*TST_PrimeSize*/
        64*sizeof(DxUint8_t),
        /*TST_Q*/
        {0x92,0xbe,0x5a,0xf9,0x2b,0xf7,0x86,0x7d,0x26,0xd2,0x3c,0x06,0x11,0x23,0x67,0xb4,
         0xfc,0x3e,0x45,0x30,0x22,0x18,0xe4,0xac,0xa1,0xbe,0xea,0x60,0xc9,0x13,0x02,0xa9,
         0xbb,0xf1,0x2e,0x89,0xf3,0x18,0xd4,0x20,0xbb,0x02,0x93,0x07,0x7c,0xf1,0x78,0x4f,
         0xbf,0x48,0x93,0x38,0x7b,0x11,0x10,0x2b,0xdf,0xe0,0x9a,0x36,0x57,0xc4,0x83,0xe7},
        /*TST_QSize*/
        64*sizeof(DxUint8_t),   
        /*TST_hashFunc*/
        CRYS_DH_HASH_SHA1_mode,
        /*TST_DerFunc_mode*/
        CRYS_DH_ASN1_Der_mode,
        /*TST_KeyLenInBits*/
        128,
    }, 
    #endif

    #if TST_USE_DH_1024_PRIME
	{ 
		{"Acceptance test - DH ANSI9.42/Prime-1024/Generator-1024/Q-160/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"}, 
			/*TST_Generator - G*/
		{0x21 ,0x4d ,0xa9 ,0x83 ,0x5f ,0xc0 ,0xa4 ,0x78 ,0x8b ,0xdb ,0x43 ,0x35 ,0xf5 ,0x63 ,0x92 ,0xcc 
		,0x98 ,0xe4 ,0xe5 ,0x33 ,0xa5 ,0xde ,0xc8 ,0xe0 ,0xe6 ,0x29 ,0x6e ,0xbd ,0x24 ,0xd4 ,0x4a ,0x55
		,0xa0 ,0x0c ,0xa0 ,0x76 ,0x15 ,0x04 ,0x35 ,0x1c ,0xae ,0x3f ,0x8c ,0x7f ,0x9f ,0xbc ,0x3c ,0x94 
		,0x14 ,0x38 ,0xc6 ,0x1c ,0xdb ,0x45 ,0x74 ,0x36 ,0xc2 ,0xcc ,0xf3 ,0x7a ,0x3a ,0x30 ,0x6d ,0x99
		,0xfd ,0xb4 ,0x91 ,0xa7 ,0xc2 ,0xa8 ,0x0e ,0x14 ,0x6e ,0xdd ,0x1c ,0xe8 ,0xda ,0xc2 ,0xed ,0x1a
		,0x7b ,0x8c ,0x13 ,0x18 ,0x29 ,0x84 ,0x4b ,0x55 ,0x31 ,0x65 ,0x03 ,0x69 ,0xc6 ,0xfb ,0x80 ,0x81
		,0x8f ,0xd0 ,0xb3 ,0x35 ,0x25 ,0xfe ,0x4a ,0x9d ,0xb1 ,0x7b ,0xb9 ,0xdf ,0xf3 ,0x79 ,0x51 ,0x3a 
		,0x49 ,0xc6 ,0x9d ,0xa0 ,0x9e ,0xda ,0x44 ,0x93 ,0x50 ,0x14 ,0x74 ,0x6b ,0x8a ,0xcf ,0xd3 ,0x58},  
		/*TST_GeneratorSize;*/
		128*sizeof(DxUint8_t),
		/*TST_Prime - P*/
		{0xE0,0x01,0xE8,0x96,0x7D,0xB4,0x93,0x53,0xE1,0x6F,0x8E,0x89,0x22,0x0C,0xCE,0xFC,
		0x5C,0x5F,0x12,0xE3,0xDF,0xF8,0xF1,0xD1,0x49,0x90,0x12,0xE6,0xEF,0x53,0xE3,0x1F,
		0x02,0xEA,0xCC,0x5A,0xDD,0xF3,0x37,0x89,0x35,0xC9,0x5B,0x21,0xEA,0x3D,0x6F,0x1C,
		0xD7,0xCE,0x63,0x75,0x52,0xEC,0x38,0x6C,0x0E,0x34,0xF7,0x36,0xAD,0x95,0x17,0xEF,
		0xFE,0x5E,0x4D,0xA7,0xA8,0x6A,0xF9,0x0E,0x2C,0x22,0x8F,0xE4,0xB9,0xE6,0xD8,0xF8,
		0xF0,0x2D,0x20,0xAF,0x78,0xAB,0xB6,0x92,0xAC,0xBC,0x4B,0x23,0xFA,0xF2,0xC5,0xCC,
		0xD4,0x9A,0x0C,0x9A,0x8B,0xCD,0x91,0xAC,0x0C,0x55,0x92,0x01,0xE6,0xC2,0xFD,0x1F,
		0x47,0xC2,0xCB,0x2A,0x88,0xA8,0x3C,0x21,0x0F,0xC0,0x54,0xDB,0x29,0x2D,0xBC,0x45},
		/*TST_PrimeSize*/
		128*sizeof(DxUint8_t),
		/*TST_Q*/
		{0x86,0x47,0x17,0xA3,0x9E,0x6A,0xEA,0x7E,0x87,0xC4,0x32,0xEE,0x77,0x43,0x15,0x16,
		0x96,0x70,0xC4,0x99},
		/*TST_QSize*/
		20*sizeof(DxUint8_t), 
		/* TST_FactorJ */
		{
		0x01,0xAB,0x11,0xC9,0x04,0x2D,0xA0,0xE3,0xF6,0x71,0x43,0x48,0xD2,0xD7,0x3F,0x88,
		0xF0,0xD4,0x69,0x96,0xDB,0xA7,0x36,0xB7,0x68,0x71,0x10,0x4E,0x41,0xF3,0x17,0xEC,
		0x38,0x43,0x95,0x30,0xA8,0x1A,0x62,0xA8,0x8A,0xB9,0xEB,0x2E,0x0E,0x2E,0x5F,0xE7,
		0x25,0x2D,0xD2,0x2E,0x00,0xEF,0x12,0x0E,0x3F,0x9F,0x91,0xC3,0x6C,0x8B,0x06,0x0D,
		0x2D,0x29,0x5A,0x20,0x26,0x49,0x30,0x82,0xB8,0x47,0x7C,0xB7,0x9A,0xD9,0xB6,0x6C,
		0x74,0xE2,0xA2,0x8D,0x1A,0xE1,0xD1,0x65,0xB6,0x8D,0xE5,0xCE,0xA4,0x55,0xF6,0xAA,
		0xBA,0xC2,0x2A,0xDD,0x85,0x47,0xAB,0xBC,0x97,0xAA,0x76,0x44,0xE4
		},
		/* TST_FactorJSize */
		109 *sizeof(DxUint8_t), 
		/* TST_Seed */
		{
		0xD5,0x01,0x4E,0x4B,0x60,0xEF,0x2B,0xA8,0xB6,0x21,0x1B,0x40,0x62,0xBA,0x32,0x24,
		0xE0,0x42,0x7F,0x4F
		},
		/* TST_SeedSize */
		160, /* in bits */
		/*TST_hashFunc*/
		CRYS_DH_HASH_SHA1_mode,
		/*TST_DerFunc_mode*/
		CRYS_DH_ASN1_Der_mode,
		/*TST_KeyLenInBits*/
		128,
	},
	#endif
    #if TST_USE_DH_2048_PRIME
    { 
        {"Acceptance test - DH ANSI9.42/Prime-2048/Generator-2048/Q-160/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"},
        /*TST_Generator - G*/
		{0x6a, 0xdc, 0xe6, 0x26, 0x4f, 0xf7, 0xd9, 0x8e, 0x63, 0xca, 0x9a, 0xce, 0x96, 0x67, 0x7c, 0xe2, 
		0x94, 0x5a, 0x92, 0x67, 0x9d, 0xa6, 0xd3, 0xa0, 0xfd, 0x0e, 0x0e, 0x60, 0x10, 0xc3, 0x8b, 0x5f, 
		0x7a, 0x15, 0x7b, 0xd8, 0x73, 0x99, 0x8f, 0x93, 0xbe, 0x8d, 0x85, 0x8d, 0x13, 0x05, 0x8e, 0x0c,
		0x46, 0x73, 0x96, 0xdd, 0x60, 0xde, 0x7b, 0xd2, 0xb0, 0x1c, 0x4f, 0x36, 0x41, 0x31, 0xf0, 0xaa, 
		0x4b, 0x4e, 0xca, 0xbb, 0x1e, 0x18, 0xc6, 0x97, 0x13, 0xe4, 0x9a, 0xdd, 0x7f, 0x51, 0x59, 0x80,
		0x97, 0xe7, 0x57, 0x67, 0x89, 0xa8, 0x91, 0x2b, 0x9f, 0x18, 0x82, 0x42, 0x4e, 0xcc, 0xbf, 0xc2,
		0xab, 0x6d, 0x7f, 0xdd, 0x56, 0xf6, 0x93, 0xb3, 0xe9, 0x8b, 0x3a, 0xc9, 0x75, 0xd2, 0xf3, 0x7a, 
		0x14, 0x3f, 0xe1, 0x1c, 0x5c, 0xd9, 0x80, 0x40, 0x3c, 0x8e, 0xf4, 0x46, 0x51, 0x80, 0x52, 0xce, 
		0xc0, 0xd6, 0xe6, 0x1a, 0xba, 0x51, 0x69, 0x6e, 0xf7, 0xf9, 0x05, 0x79, 0xdc, 0x27, 0x4a, 0xa3, 
		0x9c, 0x96, 0x34, 0x9a, 0x3e, 0x56, 0x82, 0xac, 0xdf, 0xc3, 0x26, 0x6a, 0xc1, 0xe8, 0x91, 0x1c,
		0xe3, 0x4d, 0x6b, 0xab, 0x26, 0x06, 0x59, 0x24, 0xbf, 0xcf, 0xbd, 0xcc, 0xbc, 0x42, 0xc8, 0xf7, 
		0x6d, 0x4d, 0x29, 0xc2, 0x3b, 0x9e, 0x72, 0xfc, 0x5e, 0xeb, 0xa0, 0x0f, 0x59, 0x12, 0x04, 0x1f, 
		0xc3, 0xbf, 0xd2, 0xa7, 0x8e, 0x35, 0x94, 0x69, 0x65, 0x71, 0x30, 0x30, 0x4d, 0xb2, 0xfe, 0xa4, 
		0xad, 0x0e, 0xfb, 0x72, 0x29, 0xf7, 0xd0, 0xa6, 0xf4, 0x95, 0xb5, 0x23, 0xd4, 0x3c, 0x54, 0x50, 
		0x2c, 0x1b, 0xc2, 0xf5, 0x72, 0xd8, 0xa9, 0xa5, 0x22, 0x2b, 0xf9, 0x09, 0x03, 0xf1, 0x46, 0x95, 
		0x44, 0x68, 0x8c, 0x2c, 0xd0, 0xbf, 0xa6, 0x6a, 0x71, 0x7a, 0x08, 0x14, 0x2c, 0x38, 0x03, 0x84},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
		/*TST_Prime - P*/
		{0xB5,0x32,0xB3,0x50,0x76,0xFE,0xDE,0xC9,0x3B,0xF5,0x80,0xA1,0x25,0x92,0xC3,0x96,
		0xC6,0xC9,0x62,0x19,0xE1,0x86,0x07,0xA7,0x38,0xAA,0x78,0x3C,0x32,0xDB,0x0F,0xD7,
		0x56,0x4E,0xEC,0xA9,0x59,0x0E,0xE2,0x4B,0x23,0x0D,0x5D,0xF2,0x3D,0x7E,0xCD,0x31,
		0x53,0x2B,0xD2,0xEE,0x91,0x4E,0xD9,0xEF,0x82,0x0A,0xE3,0x14,0x96,0xB2,0xFA,0xBA,
		0xAF,0x1E,0x9A,0xC1,0x88,0x01,0xFB,0x2D,0xF3,0xAD,0xB9,0xAB,0x4B,0xC0,0x69,0x24,
		0xEC,0x9B,0xAD,0x7E,0xF2,0xCB,0x2D,0x63,0x0E,0x37,0xE9,0x19,0x30,0x7E,0x7D,0xEC,
		0x33,0xC5,0x38,0xF7,0x07,0x6A,0x15,0xFE,0x72,0x6B,0xAC,0x37,0x6B,0x13,0x67,0xFA,
		0x97,0x44,0x2A,0xDD,0x05,0x25,0xB5,0x36,0xA9,0xA2,0x29,0x4A,0x2C,0x8D,0x5A,0x55,
		0x24,0x1F,0xA6,0x20,0x21,0xB5,0xA5,0x98,0xB7,0xE1,0x98,0x72,0x2E,0x6A,0x11,0x93,
		0x0A,0x88,0x47,0x54,0x8D,0xF3,0xB7,0x58,0xA9,0x5E,0x26,0x81,0x3D,0xB5,0x6C,0xC7,
		0x85,0x36,0x19,0xE2,0x51,0xFB,0x68,0x51,0xD8,0xFA,0xD1,0x07,0x33,0x5A,0x17,0x3C,
		0xB0,0x1B,0xEF,0xA2,0x4C,0x06,0xD0,0x68,0x8F,0xD0,0x67,0xFA,0x1D,0x7C,0x10,0xD8,
		0x81,0x1D,0xBB,0x02,0x61,0x4E,0xC7,0x29,0x95,0x4A,0xE4,0x3E,0x0B,0xFE,0xD2,0x03,
		0xD0,0xCC,0x6F,0x1A,0xB4,0xAE,0xB9,0xFB,0x29,0xB5,0xEC,0x1E,0x2F,0x74,0x40,0x80,
		0x87,0xA3,0x79,0xB5,0x20,0x4A,0xBC,0xDB,0x5D,0x28,0x77,0x43,0xEE,0x58,0x4D,0x40,
		0x2C,0xA1,0x87,0xA9,0xE6,0x89,0xC4,0xF8,0xDB,0xD5,0x67,0x82,0x85,0xF3,0xE0,0x9D},
		/*TST_PrimeSize*/
		256*sizeof(DxUint8_t),
		/*TST_Q*/
		{0xF1,0xC1,0xEB,0x18,0xAA,0x94,0xB1,0xA4,0xB8,0xA4,0x97,0x4B,0x26,0xE5,0xC9,0x0D,
		0x03,0x53,0xD5,0xAD},
		/*TST_QSize*/
		20*sizeof(DxUint8_t), 
		/* TST_FactorJ */
		{
		0xBF,0xDF,0x73,0x69,0x00,0x19,0x3C,0x66,0x1A,0xA1,0x2A,0x0B,0xF1,0x55,0xE6,0xAA,
		0xA6,0xA6,0x08,0x16,0xCA,0x2A,0xB5,0x5B,0x69,0x4C,0xB7,0xE4,0x82,0xF3,0x56,0xB6,
		0x57,0x01,0xD8,0xAD,0x8F,0x64,0x63,0x62,0x4E,0xD0,0x8A,0xE4,0x4E,0x2C,0xF6,0x73,
		0xE9,0x53,0xF9,0xD2,0x98,0x63,0x6B,0x53,0xD8,0xEC,0x1B,0xB7,0x8F,0xCC,0xA3,0xBB,
		0x6E,0x88,0xE2,0x32,0x6D,0x2F,0x0C,0xC9,0xA0,0xA0,0xFB,0x30,0x72,0xED,0x5B,0xA1,
		0x8F,0x4E,0xD3,0xC9,0x26,0xB1,0x9A,0x7F,0xB2,0x70,0x65,0x65,0xB7,0xB8,0x32,0xB3,
		0xEE,0x78,0xAF,0xC0,0x21,0x49,0x39,0xA8,0x30,0x7A,0x29,0x72,0x49,0x85,0xEB,0x98,
		0x5F,0x94,0xC6,0x4D,0xFD,0x92,0xF6,0x6A,0x6F,0x10,0xDC,0x6F,0x23,0x14,0xB6,0x17,
		0xA6,0x0C,0x67,0xC7,0x2E,0xF6,0x9D,0x03,0x09,0x29,0xB9,0xB9,0x95,0x2E,0x62,0x2A,
		0xD4,0xFE,0x16,0xBD,0x5C,0x80,0xAE,0xDB,0x59,0xC7,0x4D,0xC0,0x1E,0x28,0xB2,0x74,
		0x9B,0x0D,0x08,0x6D,0x6A,0x76,0x88,0x5B,0xD6,0x72,0xC9,0x37,0xC7,0xE5,0x67,0xFD,
		0xE5,0xDB,0x14,0x1C,0x80,0x71,0xB9,0x44,0x07,0x92,0xDC,0xC3,0x29,0x79,0x09,0x64,
		0xDE,0x60,0xF6,0x0C,0x70,0xBC,0x9A,0xED,0x7F,0x63,0x9D,0x00,0xD7,0xB5,0x73,0xC9,
		0x27,0xD7,0xDF,0xD0,0x53,0x35,0xB5,0xC5,0xBC,0x1C,0x78,0xA0,0x2A,0x34,0xA2,0x07,
		0x52,0x1F,0xE4,0xB6,0x3E,0xD1,0x8C,0xED,0xA7,0xEB,0xDE,0x8C
		},
		/* TST_FactorJSize */
		236 *sizeof(DxUint8_t), 
		/* TST_Seed */
		{
		0xA7,0x40,0x74,0x6C,0xF5,0x40,0x7F,0x94,0xC0,0x00,0xAD,0xF1,0x93,0x9B,0x0A,0x40,
		0xE9,0xBA,0x45,0x91
		},
		/* TST_SeedSize */
		160, /* in bits */
        /*TST_hashFunc*/
        CRYS_DH_HASH_SHA1_mode,
        /*TST_DerFunc_mode*/
        CRYS_DH_ASN1_Der_mode,
        /*TST_KeyLenInBits*/
        256,                  
    },
    #endif
};


const int TST_NumberOf_DH_PKCS3_AcceptanceTests   = sizeof(TST_DH_Acceptance_PKCS3_TestDataStruct)/sizeof(TST_DH_Acceptance_PKCS3_TestDataStruct[0]); 
const int TST_NumberOf_DH_ANSI942_AcceptanceTests = sizeof(TST_DH_Acceptance_ANSI942_TestDataStruct)/sizeof(TST_DH_Acceptance_ANSI942_TestDataStruct[0]);
#endif

